/*
 * Decompiled with CFR 0.152.
 */
package net.ssterling.updatechecker;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class UpdateChecker {
    private static String project_id;
    private static String current_version;

    public UpdateChecker(String project_id, String current_version) {
        UpdateChecker.project_id = project_id;
        UpdateChecker.current_version = current_version;
    }

    public static String check() throws Throwable {
        URL update_url = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + project_id);
        URLConnection update_conn = update_url.openConnection();
        String new_version = new BufferedReader(new InputStreamReader(update_conn.getInputStream())).readLine();
        return UpdateChecker.versionIsHigher(new_version, current_version) ? new_version : null;
    }

    private static boolean versionIsHigher(String version_a_str, String version_b_str) {
        ComparableVersion version_a = new ComparableVersion(version_a_str);
        ComparableVersion version_b = new ComparableVersion(version_b_str);
        return version_a.compareTo(version_b) > 0;
    }
}

